*****************************************************************************
**                                                                         **
** Eagleripper: Activision Pro                                             **
**                                                                         **
** Project: Eagleplayer 2.04                                               **
** Authors: Jan Blumenthal & Henryk Richter                                **
** Start  : 1993/01/09                                                     **
** $Header$                                                                **
**                                                                         **
*****************************************************************************
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program (See the included file COPYING);
** if not, write to the Free Software Foundation, Inc.,
** 675 Mass Ave, Cambridge, MA 02139, USA.
**
***************************************************************************** 

*-----------------------------------------------------------------------------*
*			      Eagleripper V1.0				      *
*			       Activision Pro				      *
*-----------------------------------------------------------------------------*
Test	= 1
		incdir	include:
		include	misc/eagleplayerripper.i
		include	exec/exec_lib.i
			
	if	Test
	*lea	data+1266,a0
	*lea	data+1266,a0
	lea	data+60,a0
	*lea	AP_Tags,a0
	move.l	#datasize,d0
	move.l	a0,a5
	move.l	a0,a4
	move.l	d0,d4
	move.l	d0,d6
wait:	move.l	a5,a1
	move.l	a4,a0
	move.l	d4,d0
	move.l	(a1),d1
	bsr	AP_Ripp2
	tst.l	d0
	beq.s	.Ja
	addq.l	#2,a5
	subq.l	#2,d6
	blt.s	.Err
	btst	#6,$bfe001
	bne.s	wait
.err:	moveq	#-1,d0
.ret:	illegal

.ja:	move.l	d1,d0
	*bsr	GetModuleName
	move.l	d0,a0
	moveq	#0,d0
	bra.s	.Ret
	endc
		RIPPERHEADER	AP_Tags

	dc.b	"Activision Pro EagleRipper V1.0",10
	dc.b	"done by Eagleeye/DFT 28.08.97",0
	even

AP_Tags:	dc.l	RPT_Formatname,.Formatname
		dc.l	RPT_Ripp1,AP_Ripp2
		dc.l	RPT_RequestRipper,1
		dc.l	RPT_Version,1<<16!0
		dc.l	RPT_Creator,.Creator
		dc.l	RPT_Prefix,.Prefix
		dc.l	RPT_Playername,.Playername
		dc.l	0

.Creator:	dc.b	"Activision Pro, adapted by DEFECT",0
.Playername:
.Formatname:	dc.b	"Activision Pro",0
.Prefix:	dc.b	"AVP.",0
		even

*-----------------------------------------------------------------------------*
* Input: a0=Adr (start of memory)
*	 d0=Size (size of memory)
*	 a1=current adr
*	 d1=(a1.l)
* Output:d0=Error oder NULL
*	 d1=Size
*	 a0=Startadr (data)
*-----------------------------------------------------------------------------*
AP_Ripp2:	cmp.l	#$48e7fcfe,d1
		beq.s	.Weiter
		cmp.l	#$48e700c0,d1
		beq.s	.Weiter
		lsr.l	#8,d1
		lsr.l	#8,d1
		cmp.w	#$6000,d1
		beq.s	.Weiter
		rts


.Weiter:	movem.l	d4/a4,-(a7)
		move.l	a1,a4
*^^^^^

		move.l	d0,d4
		sub.l	a1,d4
		add.l	a0,d4
		
		move.l	d4,d2
		move.l	a1,a2
		move.l	a4,a0
		lea	CheckData1(pc),a1
		move.l	#CheckData1Size/2-1,d1
		bsr	CheckString
		bne.s	.Test2
	*	move.l	a0,Load_InitAdr

		lea	CheckData2(pc),a1
		move.l	#CheckData2Size/2-1,d1
		bsr	FindBytes
		bne.w	.Error
	*	move.l	a0,Load_MusicAdr
		moveq	#0,d1
		cmp.w	#$4e75,40(a2)
		bne.s	.Normal
		moveq	#2,d1
.Normal:
	*	move.l	d1,Load_FirstSong
		bra.w	.JA

.Test2:		move.l	a4,a0
		move.l	d4,d2

		lea	CheckData3(pc),a1
		move.l	#CheckData3Size/2-1,d1
		bsr	CheckString
		bne.s	.Test3
	*	move.l	a0,Load_InitAdr

		lea	CheckData4(pc),a1
		move.l	#CheckData4Size/2-1,d1
		bsr	FindBytes
		bne.w	.Error
	*	move.l	a0,Load_MusicAdr
	*	move.l	#2,Load_FirstSong
		bra.w	.Ja

.Test3:		move.l	a4,a0
		move.l	d4,d2

		cmp.w	#$6000,(a0)
		bne.w	.Error
		cmp.w	#$6000,4(a0)
		bne.w	.Error
		cmp.w	#$6000,8(a0)
		bne.s	.Error
		cmp.w	#$6000,12(a0)
		bne.s	.Error
		cmp.w	#$6000,16(a0)
		bne.s	.Error
		cmp.w	#$6000,20(a0)
		bne.s	.Error
		cmp.w	#$6000,24(a0)
		bne.w	.Error
		cmp.w	#$6000,28(a0)
		bne.w	.Error
		cmp.w	#$6000,32(a0)
		bne.w	.Error
		cmp.w	#$6000,32(a0)
		bne.w	.Error
		move.w	5*4+2(a0),d0
		lea	5*4+2(a0,d0.w),a1
		*cmp.w	#$7000,(a1)
		*beq.s	.Error
		cmp.l	#$2f0841fa,(a1)
		bne.s	.Error
	*	move.l	a1,Load_InitAdr
		move.w	6*4+2(a0),d0
		lea	6*4+2(a0,d0.w),a1
	*	move.l	a1,Load_MusicAdr
	*	move.l	#2,Load_FirstSong
.Ja:		moveq	#0,d0
		moveq	#-1,d1
		move.l	a4,a0
.Return:	movem.l	(a7)+,d4/a4
		rts

.Error:		moveq	#-1,d0
		bra.s	.Return


*-----------------------------------------------------------------------------*
* a0=Adr
* d2=Size
FindBytes:	move.l	d3,-(a7)
		move.l	d1,d3
.Next:		move.l	d3,d1
		bsr	CheckString
		beq.s	.Gefunden
		addq.l	#2,a0
		subq.l	#2,d2
		bgt.s	.Next
		move.l	(a7)+,d3
		moveq	#-1,d0
		rts

.Gefunden:	move.l	(a7)+,d3
		moveq	#0,d0
		rts

*-----------------------------------------------------------------------------*
* Input: a0=Adr 1
*	 a1=Adr 2
*	 d1=Size
* Output:d0=Error oder NULL
*-----------------------------------------------------------------------------*
CheckString:	movem.l	a0/a1/d2,-(a7)
		moveq	#-1,d0
.CheckIt:	move.w	(a1)+,d2
		cmp.w	#-1,d2
		beq.s	.DiesNicht
		cmp.w	(a0),d2
		bne.s	.NE
.DiesNicht:	addq.l	#2,a0
		dbf	d1,.CheckIt
		moveq	#0,d0
.Ne:		movem.l	(a7)+,a0/a1/d2
		rts


*-----------------------------------------------------------------------------*
CheckData1:	movem.l	d0-d5/a0-a6,-(sp)
		asl.w	#4,d1
		moveq	#0,d0
CheckData1Size	= *-CheckData1

*-----------------------------------------------------------------------------*
CheckData2:	movem.l	d0-d5/a0-a6,-(sp)
		dc.w	$41fa,-1	;lea	lbL000874(pc),a0
		dc.w	$43fa,-1	;lea	lbL0008F2(pc),a1
		dc.w	$47fa,-1	;lea	lbW000976(pc),a3
		dc.w	$4bfa,-1	;lea	lbW000C22(pc),a5
		movea.l	#$DFF0A0,a6
CheckData2Size	= *-CheckData2

*-----------------------------------------------------------------------------*
CheckData3:	movem.l	a0/a1,-(a7)
		dc.w	$41fa,-1	;lea	lbL000874(pc),a0
		dc.w	$43fa,-1	;lea	lbL0008F2(pc),a1
		andi.l	#$000000ff,d0
		asl.w	#2,d0
CheckData3Size	= *-CheckData3

*-----------------------------------------------------------------------------*
CheckData4:	movem.l	d0-d5/a0-a6,-(sp)
		dc.w	$41fa,-1	;lea	lbL000874(pc),a0
		dc.w	$43fa,-1	;lea	lbL0008F2(pc),a1
		dc.w	$4bfa,-1	;lea	lbW000976(pc),a3
		movea.l	#$DFF0A0,a6
CheckData4Size	= *-CheckData4




	if	test
data:		incdir	"Modules:Verschiedenes/"
	*	ds.b	200

		*incbin	"AVP.9Lives"                    
		*incbin	"AVP.AtomicRoboKid"             
		incbin	"AVP.BritishMus"                
		*incbin	"AVP.DGeneration"               
		*incbin	"AVP.GermanMus"                 
		*incbin	"AVP.Hunter"                    
		*incbin	"AVP.IndyIVaction"              
		*incbin	"AVP.LegendsOfValour"           
		*incbin	"AVP.LOV-Effects"               
		*incbin	"AVP.RTypeII"                   
		*incbin	"AVP.SpindizzyWorlds"           
		*incbin	"AVP.Spindizzy_Worlds"          
		*incbin	"AVP.ThunderHawk"               







datasize	= *-data
	endc


